clear all
set matsize 10000
set maxvar 10000
set more off

cd "\IRI data"
	
*** Program to estimate trends in price

	import delimited "iri_wm_panel_new.csv"

	merge m:1 iri_key using entries_wide_11.dta
	drop _merge
	
** Create WM post-entry and entry week indicator

	local d = 5
	rename wmid* idwm*
	forvalues i=1/19 {
		capture gen wm`i' = (weekid >= week`i')
		capture gen enter`i' = (weekid == week`i')
		capture gen since`i' = weekid - week`i'
		capture replace since`i' = . if dis`i' > `d'
		capture replace dis`i' = 0 if wm`i' == 0
		}
		egen wm = rowtotal(wm*)
		egen enter = rowtotal(enter*)
		
		encode market, gen(mkt)
	
** Setup
	rename iri_key stores
	xtset stores weekid
	
/*	egen dis = rowtotal(dis*)
	forvalues i=1/19 {
		capture gen dis`i'_2 = dis`i'^2
		capture gen dis`i'_3 = dis`i'^3
		}
	egen dis_sq = rowtotal(dis*_2)
	egen dis_cu = rowtotal(dis*_3)
	drop dis*_2 dis*_3
*/	
	* Distance spline
	forvalues s=1/1 {
		forvalues i=1/24 {
			capture gen I_`i'_`s' = (dis`i' <= `s' & dis`i' > 0 )
			}
		egen wm_`s' = rowtotal(I_*_`s')
		drop I*
		}

	forvalues s=3(2)11 {
		local s0 = `s'-2
		forvalues i=1/24 {
			capture gen I_`i'_`s' = (dis`i' <= `s' & dis`i' > `s0' )
			}
		egen wm_`s' = rowtotal(I_*_`s')
		drop I*
		}
	
** Merge in store names
	rename stores iri_key
	merge m:1 iri_key using store_names.dta
	drop if _merge == 2
	drop _merge
	rename iri_key stores
	
	* Merge in chain info
	merge m:1 name using chain.dta
	drop _merge
	
	gen missing_chain = (chainid ==.)
	
	replace firmtype = 3 if firmtype == 4
	encode name, gen(chain)
	replace chain = 0 if missing_chain == 1
	
** Treatment groups
	by stores, sort: egen treat_nwm = max(wm)
	by stores, sort: egen wm0 = min(wm)
	
	gen wm_diff = treat_nwm - wm0
	
** Time since / to entry
	
	local d = 8
	* Post
	local max = 104
	local max0 = `max' - `d' + 1
	forvalues t=1(`d')`max0' {
		local k = `t' + `d'
		forvalues i=1/19 {
			capture gen timesincetreat`t'_`i' = (since`i' < `k' & since`i' >= `t')
			}
		egen timesincetreat`d'_`t' = rowtotal(timesincetreat`t'_*)
		drop timesincetreat`t'_*
		}
	forvalues i=1/19 {
		capture gen timesincetreat`max'_`i' = (since`i' > `max' & since`i' < .)
		}	
	egen timesincetreat`d'_`max' = rowtotal(timesincetreat`max'_*)
	drop timesincetreat`max'_*
		
	* Pre
	local max = 104
	local max0 = `max' - `d' + 1
	forvalues t=1(`d')`max0' {
		local k = `t' + `d'
		forvalues i=1/19 {
			capture gen timetotreat`t'_`i' = (since`i' > -`k' & since`i' <= -`t')
			}
		egen timetotreat`d'_`t' = rowtotal(timetotreat`t'_*)
		drop timetotreat`t'_*
		}
	
	drop since*
	compress
	
** Create variables

	merge m:1 monthid using cpi.dta
	drop _merge
	
	foreach var in carbbev coffee coldcer fzdinent fzpizza hotdog margbutr mayo mustketc peanbutr saltsnck soup spagsauc sugarsub yogurt {
		gen `var'_price = (`var' / `var'_vol_sales) / cpi * 100
		drop `var' `var'_vol_sales
		}
		
	* Fix outlier
	qui sum fzdinent_price, detail
	replace fzdinent_price = . if fzdinent_price > `r(p99)'

	foreach var in carbbev coffee coldcer fzdinent fzpizza hotdog margbutr mayo mustketc peanbutr saltsnck soup spagsauc sugarsub yogurt {
		gen logp_vol_`var' = log(`var'_price)
		gen logp_avg_`var' = log(`var'_avg_price / cpi * 100)
		}
		
	compress

keep stores timetotreat* timesincetreat*  weekid wm wm_* mkt chain* enter logp* firmtype treat_nwm week*
	
** Stack datasets

	preserve
	foreach var in carbbev coffee coldcer fzdinent fzpizza hotdog margbutr mayo mustketc peanbutr saltsnck soup spagsauc sugarsub yogurt {
		keep stores timetotreat* timesincetreat* weekid wm wm_* mkt chain* enter firmtype logp*_`var' treat_nwm week*
		gen category = "`var'"
		rename logp_vol_`var' logp_vol
		rename logp_avg_`var' logp_avg
		save `var'.dta, replace
		restore, preserve
		}
	restore, not
		
	clear
	foreach var in carbbev coffee coldcer fzdinent fzpizza hotdog margbutr mayo mustketc peanbutr saltsnck soup spagsauc sugarsub yogurt {
		append using `var'.dta
		erase `var'.dta
		}
		
	encode category, gen(cat)
	egen storecat = group(stores cat)
	xtset storecat weekid
		
** Regressions
	cd "\Results"
	
	foreach var of varlist logp_vol {
		xtreg `var' enter timesincetreat* i.weekid i.cat#c.weekid i.cat#c.weekid#c.weekid, fe cluster(stores)
			outreg2 using final_`var'_trends, excel
		xtreg `var' timetotreat*_1 enter timesincetreat* i.weekid i.cat#c.weekid i.cat#c.weekid#c.weekid, fe cluster(stores)
			outreg2 using final_`var'_trends, excel
		xtreg `var' timetotreat* enter timesincetreat* i.weekid i.cat#c.weekid i.cat#c.weekid#c.weekid, fe cluster(stores)
			outreg2 using final_`var'_trends, excel
		xtreg `var' timetotreat* enter timesincetreat* i.weekid i.cat#c.weekid i.cat#c.weekid#c.weekid i.mkt#c.weekid i.mkt#c.weekid#c.weekid, fe cluster(stores)
			outreg2 using final_`var'_trends, excel
		xtreg `var' timetotreat* enter timesincetreat* i.weekid i.cat#c.weekid i.cat#c.weekid#c.weekid i.mkt#c.weekid i.mkt#c.weekid#c.weekid i.treat_nwm#c.weekid i.treat_nwm#c.weekid#c.weekid, fe cluster(stores)
			outreg2 using final_`var'_trends, excel
		}
		
		


